/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation.
 * This program is distributed but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 */

//---------------------------------------------------------------------------
#include <algorithm>
#include <cstring>
using namespace std;

#include <vcl.h>
#pragma hdrstop

#include "XOSLFontMain.h"
#include "About.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "CGAUGES"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner), FontViewer(PaintBox1->Canvas)
{
	XCFLoaded = false;
    TTFLoaded = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
    if (XCFOpenDialog->Execute()) {
    	Button3->Enabled = false;
    	FontViewer.SelectFontFile(XCFOpenDialog->FileName.c_str());
        XCFLoaded = true;
        TTFLoaded = false;
	    PaintBox1->Refresh();
        Label3->Caption = FontViewer.GetTextHeight();;
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::PaintBox1Paint(TObject *Sender)
{
    if (XCFLoaded) {
    	DisplayXCF();
    }
    else if (TTFLoaded) {
    	DisplayTTF();
    }
}

void TForm1::DisplayXCF()
{
	unsigned char CharStr[2];
    int CharIndex;
    int Left, Top;

    CharStr[1] = 0;
	for (Top = CharIndex = 0; CharIndex < 256; Top += 32) {
       	for (Left = 5; Left < 635 && CharIndex < 256; Left += 35, ++CharIndex) {
           	CharStr[0] = static_cast<char>(CharIndex);
            FontViewer.TextOut(Left,Top,CharStr,clBlack);
        }
    }
}

void TForm1::DisplayTTF()
{
	char CharStr[2];
    int CharIndex;
    int Left, Top;

    CharStr[1] = 0;
    PaintBox1->Canvas->Pen->Color = clBlack;
   	PaintBox1->Canvas->Font = TTFFontDialog->Font;
	for (Top = CharIndex = 0; CharIndex < 256; Top += 32) {
       	for (Left = 5; Left < 635 && CharIndex < 256; Left += 35, ++CharIndex) {
           	*CharStr = static_cast<char>(CharIndex);
            PaintBox1->Canvas->TextOut(Left,Top,CharStr);
        }
    }


}



//---------------------------------------------------------------------------


void __fastcall TForm1::Button2Click(TObject *Sender)
{
	if (TTFFontDialog->Execute()) {
    	Button3->Enabled = true;
        XCFLoaded = false;
   	    TTFLoaded = true;

    	PaintBox1->Refresh();
    }
}
//---------------------------------------------------------------------------




void __fastcall TForm1::Button3Click(TObject *Sender)
{
	char CharStr[2];
	int Index;

	try {

	if (XCFSaveDialog->Execute()) {
    	Refresh();
    	InitEmpty();
       	CGauge1->Progress = 0;
    	CharStr[1] = 0;
        for (Index = 0; Index < 256; ++Index) {
            PaintBox2->Refresh();

			PaintBox2->Canvas->Pen->Color = clWhite;
			PaintBox2->Canvas->MoveTo(63,0);
		    PaintBox2->Canvas->LineTo(63,32);

		    PaintBox2->Canvas->Pen->Color = clBlack;
	   		PaintBox2->Canvas->Font = TTFFontDialog->Font;
            *CharStr = static_cast<char>(Index);
            PaintBox2->Canvas->TextOut(0,0,CharStr);
            ConvertChar(Index);
        	CGauge1->Progress = Index;
        }
        OutputFontFile.TextHeight;
        PaintBox2->Refresh();
        WriteFile();

		Label7->Caption = OutputFontFile.TextHeight;
		Label8->Caption = OutputFontFile.DataSize;
        Label9->Caption = OutputFontFile.DataSize * 2 + 1028;
        ShowMessage("Conversion complete");
    }

    }
    catch(int) {
    }

}
//---------------------------------------------------------------------------



void TForm1::InitEmpty()
{
	memset(&OutputFontFile,0,8192);
}

void TForm1::ConvertChar(int Index)
{
	int Left, Top;
    int PixelColor = clWhite;
    int LeftStart, LineCount;
    char Char;
    SIZE CharSize;

    OutputFontFile.FontHeader[Index].Index = OutputFontFile.DataSize;

    LineCount = 0;
    for (Top = 0; Top < 32; ++Top) {

   		for (Left = 0; Left < 64; ++Left) {
			if (PixelColor != 0) {
            	PixelColor = PaintBox2->Canvas->Pixels[Left][Top];
            	if (PixelColor == 0) {
                    ++LineCount;
                	if (OutputFontFile.DataSize == 3582) {
                    	Application->MessageBox("An XOSL Font File may not exceed 8kb","Font cannot be converted",MB_OK | MB_ICONERROR);
                    	throw 0;
                    }
                    LeftStart = Left;
                	OutputFontFile.FontData[OutputFontFile.DataSize].XOff = static_cast<unsigned short>(Left);
                	OutputFontFile.FontData[OutputFontFile.DataSize].YOff = static_cast<unsigned short>(Top);
                }
            }
            else {
            	PixelColor = PaintBox2->Canvas->Pixels[Left][Top];
				if (PixelColor != 0) {
                	OutputFontFile.FontData[OutputFontFile.DataSize].Width = static_cast<unsigned short>(Left - LeftStart);
                    ++OutputFontFile.DataSize;
                }
            }
        }
    }

    if (LineCount > 255) {
		Application->MessageBox("one or more characters consist of more than 255 lines","Font cannot be converted",MB_OK | MB_ICONERROR);
    	throw 0;
    }
    OutputFontFile.FontHeader[Index].Items = static_cast<unsigned char>(LineCount);

    Char = static_cast<char>(Index);
    GetTextExtentPoint32(PaintBox2->Canvas->Handle,&Char,1,&CharSize);
    OutputFontFile.FontHeader[Index].Width = static_cast<unsigned char>(CharSize.cx);
	if (CharSize.cy > OutputFontFile.TextHeight)
		OutputFontFile.TextHeight = static_cast<unsigned short>(CharSize.cy);

}

void TForm1::WriteFile()
{
	FILE *FileHandle;

    if ((FileHandle = fopen(XCFSaveDialog->FileName.c_str(),"wb")) == NULL) {
		Application->MessageBox("Unable to open the destination file","Error",MB_OK | MB_ICONERROR);
    	throw 0;
    }

    fwrite(&OutputFontFile,8192,1,FileHandle);
    fclose(FileHandle);

}


void __fastcall TForm1::Button4Click(TObject *Sender)
{
	AboutBox->ShowModal();
}
//---------------------------------------------------------------------------

