/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation.
 * This program is distributed but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 */

//---------------------------------------------------------------------------
#ifndef FontViewerH
#define FontViewerH
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#pragma pack(push,1)

class CFontEntry {
public:
	unsigned short Index;
    unsigned char Items;
    unsigned char Width;
};

class CCharLine {
public:
	unsigned short Width: 5;
    unsigned short YOff: 5;
    unsigned short XOff: 6;
};

class CFontFile {
public:
	unsigned short DataSize;
    unsigned short TextHeight;
	CFontEntry FontHeader[256];
    CCharLine FontData[3582];
};

#pragma pack(pop)

class CXoslFontViewer {
public:
	CXoslFontViewer(TCanvas *Canvas);
    ~CXoslFontViewer();

    void SelectFontFile(const char *FileName);
	int GetTextWidth(const char *Str);
	int GetTextHeight();

    void TextOut(int Left, int Top, const unsigned char *Text, unsigned long Color);


private:
	TCanvas &Canvas;

    CFontFile FontFile;

};

#endif
