/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation.
 * This program is distributed but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 */

//---------------------------------------------------------------------------
#include <stdio.h>

#include "FontViewer.h"

CXoslFontViewer::CXoslFontViewer(TCanvas *CanvasToUse):
	Canvas(*CanvasToUse)
{
}

CXoslFontViewer::~CXoslFontViewer()
{
}

void CXoslFontViewer::SelectFontFile(const char *FileName)
{
	FILE *FileHandle;

    if ((FileHandle = fopen(FileName,"rb")) == NULL)
    	throw "Unable to open file";

    fread(&FontFile,8192,1,FileHandle);
    fclose(FileHandle);
}



int CXoslFontViewer::GetTextWidth(const char *Str)
{
	int Length;
	const unsigned char *pStr;

	pStr = (const unsigned char *)Str;

	for (Length = 0; *pStr; Length += FontFile.FontHeader[*pStr++].Width);
	return Length;
}

int CXoslFontViewer::GetTextHeight()
{
	return FontFile.TextHeight;
}

void CXoslFontViewer::TextOut(int Left, int Top, const unsigned char *Text, unsigned long Color)
{
	int CanvasLeft, CanvasTop;
    int LineWidth;
    int DataIndex, DataCount;

    Canvas.Pen->Color = static_cast<TColor>(Color);

	for (; *Text; ++Text) {
		DataIndex = FontFile.FontHeader[*Text].Index;
        DataCount = FontFile.FontHeader[*Text].Items;
        if (DataIndex >= 3582)
        	throw;

        for (; DataCount; ++DataIndex, --DataCount) {
        	CanvasLeft = Left + FontFile.FontData[DataIndex].XOff;
            CanvasTop = Top + FontFile.FontData[DataIndex].YOff;
            LineWidth = FontFile.FontData[DataIndex].Width;

            Canvas.MoveTo(CanvasLeft,CanvasTop);
            Canvas.LineTo(CanvasLeft + LineWidth,CanvasTop);

        }
        Left += FontFile.FontHeader[*Text].Width;
    }
}



