
#include <AntiVir.h>
#include <disk.h>
#include <graph.h>
#include <mem.h>
#include <quit.h>

CAntiVirus::CAntiVirus(CFileSystem &FileSystemToUse):
	FileSystem(FileSystemToUse)
{
}

CAntiVirus::~CAntiVirus()
{
}

void CAntiVirus::Sweep()
{
	char RealMBR[512];
	char DiskMBR[512];

	GetRealMBR(RealMBR);
	if (GetDiskMBR(DiskMBR) == -1) {
		DisplayError();
		CKeyboard::WaitKeyStroke();
	}
	else {
		if (memcmp(RealMBR,DiskMBR,440) != 0) {
			DisplayWarning();
			if (CKeyboard::WaitKeyStroke() == KEY_ENTER) {
				FixMBR(DiskMBR);
				DisplayResult();
				CKeyboard::WaitKeyStroke();
			}
			Reboot();
		}
	}

}

void CAntiVirus::ClearScreen()
{
	int Width, Height;

	Graph->GetModeMetrics(Width,Height);
	Graph->Bar(0,0,Width,Height,0);
	Graph->TextOut(64,64,"--- XOSL antivir ---",STYLE_BOLD,15);
}

void CAntiVirus::DisplayError()
{
	ClearScreen();
	Graph->TextOut(64,96,"XOSL neme st z \"CURR_MBR.XCF\". Z tohoto dvodu ",STYLE_REGULAR,15);
	Graph->TextOut(64,112,"XOSL neme aktivovat antivirovou ochranu MBR.",STYLE_REGULAR,15);
	Graph->TextOut(64,144,"Stisknte libovolnou klvesu...",STYLE_REGULAR,15);
	Graph->UltraFlush();
}

void CAntiVirus::DisplayWarning()
{
	ClearScreen();
	Graph->TextOut(64,96,"UPOZORNN: XOSL zjistil, e Master Boot Record byl modifikovn.",STYLE_REGULAR,15);
	Graph->TextOut(64,112,"V potai me bt vir!",STYLE_REGULAR,15);
	Graph->TextOut(64,144,"Po stisku Enter se obnov pvodn XOSL MBR, po stisku Escape se pota restartuje...",STYLE_REGULAR,15);
	Graph->UltraFlush();
}

void CAntiVirus::DisplayResult()
{
	ClearScreen();
	Graph->TextOut(64,96,"Master boot record byl obnoven.",STYLE_REGULAR,15);
	Graph->TextOut(64,128,"Stisknte libovolnou klvesu...",STYLE_REGULAR,15);
	Graph->UltraFlush();
}

void CAntiVirus::GetRealMBR(char *RealMBR)
{
	CDisk Disk;

	Disk.Map(0x80,0);
	Disk.Read(0,RealMBR,1);
}

int CAntiVirus::GetDiskMBR(char *DiskMBR)
{
	if (FileSystem.ReadFile("CURR_MBRXCF",DiskMBR) != 512) {
		return -1;
	}
	return 0;
}


void CAntiVirus::FixMBR(const char *DiskMBR)
{
	CDisk Disk;
	char MBR[512];

	Disk.Map(0x80,0);
	Disk.Read(0,MBR,1);
	memcpy(MBR,DiskMBR,440);
	Disk.Write(0,MBR,1);
}

void CAntiVirus::Reboot()
{
	CQuit Quit(NULL);

	Quit.Reboot();
}

