#include <key.h>

const CKeyDesc CKeyboard::CzechKeyList[KEY_COUNT] = {
	{0x0100,0x0100,"Alt-Escape","Aesc",true},
	{0x011b,0x011b,"Escape","esc",true},
	{0x0221,0x0221,"!","!",false},
	{0x0231,0x0231,"1","1",false},
	{0x0300,0x0300,"Ctrl-2","C2",true},
	{0x0332,0x0332,"2","2",false},
	{0x0340,0x0340,"@","@",false},
	{0x0423,0x0423,"#","#",false},
	{0x0433,0x0433,"3","3",false},
	{0x0524,0x0524,"$","$",false},
	{0x0534,0x0534,"4","4",false},
	{0x0625,0x0625,"%","%",false},
	{0x0635,0x0635,"5","5",false},
	{0x071e,0x071e,"Ctrl-6","C6",true},
	{0x0736,0x0736,"6","6",false},
	{0x075e,0x075e,"^","^",false},
	{0x0826,0x0826,"&","&",false},
	{0x0837,0x0837,"7","7",false},
	{0x092a,0x092a,"*","*",false},
	{0x0938,0x0938,"8","8",false},
	{0x0a28,0x0a28,"(","(",false},
	{0x0a39,0x0a39,"9","9",false},
	{0x0b29,0x0b29,")",")",false},
	{0x0b30,0x0b30,"0","0",false},
	{0x0c1f,0x0c1f,"Ctrl--","C-",true},
	{0x0c2d,0x0c2d,"-","-",false},
	{0x0c5f,0x0c5f,"_","_",false},
	{0x0d2b,0x0d2b,"+","+",false},
	{0x0d3d,0x0d3d,"=","=",false},
	{0x0e00,0x0e00,"Alt-Backspace","Abs",true},
	{0x0e08,0x0e08,"Backspace","bs",true},
	{0x0e7f,0x0e7f,"Ctrl-Backspace","Cbs",true},
	{0x0f00,0x0f00,"Shift-Tab","Stab",true},
	{0x0f09,0x0f09,"Tab","tab",true},
	{0x1000,0x1000,"Alt-Q","AQ",true},
	{0x1011,0x1011,"Ctrl-Q","CQ",true},
	{0x1051,0x1051,"Q","Q",false},
	{0x1071,0x1071,"q","q",false},
	{0x1100,0x1100,"Alt-W","AW",true},
	{0x1117,0x1117,"Ctrl-W","CW",true},
	{0x1157,0x1157,"W","W",false},
	{0x1177,0x1177,"w","w",false},
	{0x1200,0x1200,"Alt-E","AE",true},
	{0x1205,0x1205,"Ctrl-E","CE",true},
	{0x1245,0x1245,"E","E",false},
	{0x1265,0x1265,"e","e",false},
	{0x1300,0x1300,"Alt-R","AR",true},
	{0x1312,0x1312,"Ctrl-R","CR",true},
	{0x1352,0x1352,"R","R",false},
	{0x1372,0x1372,"r","r",false},
	{0x1400,0x1400,"Alt-T","AT",true},
	{0x1414,0x1414,"Ctrl-T","CT",true},
	{0x1451,0x1451,"T","T",false},
	{0x1474,0x1474,"t","t",false},
	{0x1500,0x1500,"Alt-Y","AY",true},
	{0x1519,0x1519,"Ctrl-Y","CY",true},
	{0x1559,0x1559,"Y","Y",false},
	{0x1579,0x1579,"y","y",false},
	{0x1600,0x1600,"Alt-U","AU",true},
	{0x1615,0x1615,"Ctrl-U","CU",true},
	{0x1655,0x1655,"U","U",false},
	{0x1675,0x1675,"u","u",false},
	{0x1700,0x1700,"Alt-I","AI",true},
	{0x1709,0x1709,"Ctrl-I","CI",true},
	{0x1749,0x1749,"I","I",false},
	{0x1769,0x1769,"i","i",false},
	{0x1800,0x1800,"Alt-O","AO",true},
	{0x180f,0x180f,"Ctrl-O","CO",true},
	{0x184f,0x184f,"O","O",false},
	{0x186f,0x186f,"o","o",false},
	{0x1900,0x1900,"Alt-P","AP",true},
	{0x1910,0x1910,"Ctrl-P","CP",true},
	{0x1950,0x1950,"P","P",false},
	{0x1970,0x1970,"p","p",false},
	{0x1a00,0x1a00,"Alt-[","A[",true},
	{0x1a1b,0x1a1b,"Ctrl-[","C[",true},
	{0x1a5b,0x1a5b,"[","[",false},
	{0x1a7b,0x1a7b,"{","{",false},
	{0x1b00,0x1b00,"Alt-]","A]",true},
	{0x1b1d,0x1b1d,"Ctrl-]","C]",true},
	{0x1b5d,0x1b5d,"]","]",false},
	{0x1b7d,0x1b7d,"}","}",false},
	{0x1c00,0x1c00,"Alt-Enter","Aret",true},
	{0x1c0a,0x1c0a,"Ctrl-Enter","Cret,true",false},
	{0x1c0d,0x1c0d,"Enter","ret",true},
	{0x1e00,0x1e00,"Alt-A","AA",true},
	{0x1e01,0x1e01,"Ctrl-A","CA",true},
	{0x1e41,0x1e41,"A","A",false},
	{0x1e61,0x1e61,"a","a",false},
	{0x1f00,0x1f00,"Alt-S","AS",true},
	{0x1f13,0x1f13,"Ctrl-S","CS",true},
	{0x1f53,0x1f53,"S","S",false},
	{0x1f73,0x1f73,"s","s",false},
	{0x2000,0x2000,"Alt-D","AD",true},
	{0x2004,0x2004,"Ctrl-D","CD",true},
	{0x2044,0x2044,"D","D",false},
	{0x2064,0x2064,"d","d",false},
	{0x2100,0x2100,"Alt-F","AF",true},
	{0x2106,0x2106,"Ctrl-F","CF",true},
	{0x2146,0x2146,"F","F",false},
	{0x2166,0x2166,"f","f",false},
	{0x2200,0x2200,"Alt-G","AG",true},
	{0x2207,0x2207,"Ctrl-G","CG",true},
	{0x2247,0x2247,"G","G",false},
	{0x2267,0x2267,"g","g",false},
	{0x2300,0x2300,"Alt-H","AH",true},
	{0x2308,0x2308,"Ctrl-H","CH",true},
	{0x2348,0x2348,"H","H",false},
	{0x2368,0x2368,"h","h",false},
	{0x2400,0x2400,"Alt-J","AJ",true},
	{0x240a,0x240a,"Ctrl-J","CJ",true},
	{0x244a,0x244a,"J","J",false},
	{0x246a,0x246a,"j","j",false},
	{0x2500,0x2500,"Alt-K","AK",true},
	{0x250b,0x250b,"Ctrl-K","CK",true},
	{0x254b,0x254b,"K","K",false},
	{0x256b,0x256b,"k","k",false},
	{0x2600,0x2600,"Alt-L","AL",true},
	{0x260c,0x260c,"Ctrl-L","CL",true},
	{0x264c,0x264c,"L","L",false},
	{0x266c,0x266c,"l","l",false},
	{0x2700,0x2700,"Alt-;","A;",true},
	{0x273a,0x273a,":",":",false},
	{0x273b,0x273b,";",";",false},
	{0x2800,0x2800,"Alt-'","A'",true},
	{0x2822,0x2822,"\"","\"",false},
	{0x2827,0x2827,"'","'",false},
	{0x2900,0x2900,"Alt-`","Alt-`",true},
	{0x2960,0x2960,"`","`",false},
	{0x297e,0x297e,"~","~",false},
	{0x2b00,0x2b00,"Alt-\\","A\\",true},
	{0x2b1c,0x2b1c,"Ctrl-\\","C\\",true},
	{0x2b5c,0x2b5c,"\\","\\",false},
	{0x2b7c,0x2b7c,"|","|",false},
	{0x2c00,0x2c00,"Alt-Z","AZ",true},
	{0x2c1a,0x2c1a,"Ctrl-Z","CZ",true},
	{0x2c5a,0x2c5a,"Z","Z",false},
	{0x2c7a,0x2c7a,"z","z",false},
	{0x2d00,0x2d00,"Alt-X","AX",true},
	{0x2d18,0x2d18,"Ctrl-X","CX",true},
	{0x2d58,0x2d58,"X","X",false},
	{0x2d78,0x2d78,"x","x",false},
	{0x2e00,0x2e00,"Alt-C","AC",true},
	{0x2e03,0x2e03,"Ctrl-C","CC",true},
	{0x2e43,0x2e43,"C","C",false},
	{0x2e63,0x2e63,"c","c",false},
	{0x2f00,0x2f00,"Alt-V","AV",true},
	{0x2f16,0x2f16,"Ctrl-V","CV",true},
	{0x2f56,0x2f56,"V","V",false},
	{0x2f76,0x2f76,"v","v",false},
	{0x3000,0x3000,"Alt-B","AB",true},
	{0x3002,0x3002,"Ctrl-B","CB",true},
	{0x3042,0x3042,"B","B",false},
	{0x3062,0x3062,"b","b",false},
	{0x3100,0x3100,"Alt-N","AN",true},
	{0x310e,0x310e,"Ctrl-N","CN",true},
	{0x314e,0x314e,"N","N",false},
	{0x316e,0x316e,"n","n",false},
	{0x3200,0x3200,"Alt-M","AM",true},
	{0x320d,0x320d,"Ctrl-M","CM",true},
	{0x324d,0x324d,"M","M",false},
	{0x326d,0x326d,"m","m",false},
	{0x3300,0x3300,"Alt-,","A,",true},
	{0x332c,0x332c,",",",",false},
	{0x333c,0x333c,"<","<",false},
	{0x3400,0x3400,"Alt-.","A.",true},
	{0x342e,0x342e,".",".",false},
	{0x343e,0x343e,">",">",false},
	{0x3500,0x3500,"Alt-/","A/",true},
	{0x352f,0x352f,"/","/",false},
	{0x353f,0x353f,"?","?",false},
	{0x3700,0x3700,"Alt-Keypad *","A*",true},
	{0x372a,0x372a,"Keypad *","*",false},
	{0x3920,0x3920,"Space"," ",false},
	{0x3b00,0x3b00,"F1","F1",true},
	{0x3c00,0x3c00,"F2","F2",true},
	{0x3d00,0x3d00,"F3","F3",true},
	{0x3e00,0x3e00,"F4","F4",true},
	{0x3f00,0x3f00,"F5","F5",true},
	{0x4000,0x4000,"F6","F6",true},
	{0x4100,0x4100,"F7","F7",true},
	{0x4200,0x4200,"F8","F8",true},
	{0x4300,0x4300,"F9","F9",true},
	{0x4400,0x4400,"F10","F10",true},
	{0x4700,0x4700,"Home","hm",true},
	{0x4737,0x4737,"Keypad 7","7",false},
	{0x47e0,0x4700,"Home","hm",true},
	{0x4800,0x4800,"Cursor Up","cu",true},
	{0x4838,0x4838,"Keypad 8","8",false},
	{0x48e0,0x4800,"Cursor Up","cu",true},
	{0x4900,0x4900,"Page Up","pu",true},
	{0x4939,0x4939,"Keypad 9","9",false},
	{0x49e0,0x4900,"Page Up","pu",true},
	{0x4a00,0x4a00,"Alt-Keypad -","A-",true},
	{0x4a2d,0x4a2d,"Keypad -","-",false},
	{0x4b00,0x4b00,"Cursor Left","cl",true},
	{0x4b34,0x4b34,"Keypad 4","4",false},
	{0x4be0,0x4b00,"Cursor Left","cl",true},
	{0x4c00,0x4c00,"Keypad 5","k5",true},
	{0x4c35,0x4c35,"Keypad 5","5",false},
	{0x4d00,0x4d00,"Cursor Right","cr",true},
	{0x4d36,0x4d36,"Keypad 6","6",false},
	{0x4de0,0x4d00,"Cursor Right","cr",true},
	{0x4e00,0x4e00,"Alt-Keypad +","A+",true},
	{0x4e2b,0x4e2b,"Keypad +","+",false},
	{0x4f00,0x4f00,"End","end",true},
	{0x4f31,0x4f31,"Keypad 1","1",false},
	{0x4fe0,0x4f00,"End","end",true},
	{0x5000,0x5000,"Cursor Down","cd",true},
	{0x5032,0x5032,"Keypad 2","2",false},
	{0x50e0,0x5000,"Cursor Down","cd",true},
	{0x5100,0x5100,"Page Down","pd",true},
	{0x5133,0x5133,"Keypad 3","3",false},
	{0x51e0,0x5100,"Page Down","pd",true},
	{0x5200,0x5200,"Insert","ins",true},
	{0x5230,0x5230,"Keypad 0","0",false},
	{0x52e0,0x5200,"Insert","ins",true},
	{0x5300,0x5300,"Delete","del",true},
	{0x532e,0x532e,"Keypad .",".",false},
	{0x53e0,0x5300,"Delete","del",true},
	{0x5400,0x5400,"Shift-F1","SF1",true},
	{0x5500,0x5500,"Shift-F2","SF2",true},
	{0x5600,0x5600,"Shift-F3","SF3",true},
	{0x561c,0x561c,"Ctrl-\\","C\\",true},
	{0x565c,0x565c,"\\","\\",false},
	{0x567c,0x567c,"|","|",false},
	{0x5700,0x5700,"Shift-F4","SF4",true},
	{0x5800,0x5800,"Shift-F5","SF5",true},
	{0x5900,0x5900,"Shift-F6","SF6",true},
	{0x5a00,0x5a00,"Shift-F7","SF7",true},
	{0x5b00,0x5b00,"Shift-F8","SF8",true},
	{0x5c00,0x5c00,"Shift-F9","SF9",true},
	{0x5d00,0x5d00,"Shift-F10","SF10",true},
	{0x5e00,0x5e00,"Ctrl-F1","CF1",true},
	{0x5f00,0x5f00,"Ctrl-F2","CF2",true},
	{0x6000,0x6000,"Ctrl-F3","CF3",true},
	{0x6100,0x6100,"Ctrl-F4","CF4",true},
	{0x6200,0x6200,"Ctrl-F5","CF5",true},
	{0x6300,0x6300,"Ctrl-F6","CF6",true},
	{0x6400,0x6400,"Ctrl-F7","CF7",true},
	{0x6500,0x6500,"Ctrl-F8","CF8",true},
	{0x6600,0x6600,"Ctrl-F9","CF9",true},
	{0x6700,0x6700,"Ctrl-F10","CF10",true},
	{0x6800,0x6800,"Alt-F1","AF1",true},
	{0x6900,0x6900,"Alt-F2","AF2",true},
	{0x6a00,0x6a00,"Alt-F3","AF3",true},
	{0x6b00,0x6b00,"Alt-F4","AF4",true},
	{0x6c00,0x6c00,"Alt-F5","AF5",true},
	{0x6d00,0x6d00,"Alt-F6","AF6",true},
	{0x6e00,0x6e00,"Alt-F7","AF7",true},
	{0x6f00,0x6f00,"Alt-F8","AF8",true},
	{0x7000,0x7000,"Alt-F9","AF9",true},
	{0x7100,0x7100,"Alt-F10","AF10",true},
	{0x7200,0x7200,"Ctrl-SysRq","Csreq",true},
	{0x7300,0x7300,"Ctrl-Left","Ccl",true},
	{0x73e0,0x7300,"Ctrl-Left","Ccl",true},
	{0x7400,0x7400,"Ctrl-Right","Ccr",true},
	{0x74e0,0x7400,"Ctrl-Right","Ccr",true},
	{0x7500,0x7500,"Ctrl-End","Cend",true},
	{0x75e0,0x7500,"Ctrl-End","Cend",true},
	{0x7600,0x7600,"Ctrl-Page Down","Cpd",true},
	{0x76e0,0x7600,"Ctrl-Page Down","Cpd",true},
	{0x7700,0x7700,"Ctrl-Home","Chm",true},
	{0x77e0,0x7700,"Ctrl-Home","Chm",true},
	{0x7800,0x7800,"Alt-1","A1",true},
	{0x7900,0x7900,"Alt-2","A2",true},
	{0x7a00,0x7a00,"Alt-3","A3",true},
	{0x7b00,0x7b00,"Alt-4","A4",true},
	{0x7c00,0x7c00,"Alt-5","A5",true},
	{0x7d00,0x7d00,"Alt-6","A6",true},
	{0x7e00,0x7e00,"Alt-7","A7",true},
	{0x7f00,0x7f00,"Alt-8","A8",true},
	{0x8000,0x8000,"Alt-9","A9",true},
	{0x8100,0x8100,"Alt-0","A0",true},
	{0x8200,0x8200,"Alt--","A-",true},
	{0x8300,0x8300,"Alt-=","A=",true},
	{0x8400,0x8400,"Ctrl-Page Up","Cpu",true},
	{0x84e0,0x8400,"Ctrl-Page Up","Cpu",true},
	{0x8500,0x8500,"F11","F11",true},
	{0x8600,0x8600,"F12","F12",true},
	{0x8700,0x8700,"Shift-F11","SF11",true},
	{0x8800,0x8800,"Shift-F12","SF12",true},
	{0x8900,0x8900,"Ctrl-F11","CF11",true},
	{0x8a00,0x8a00,"Ctrl-F12","CF12",true},
	{0x8b00,0x8b00,"Alt-F11","AF11",true},
	{0x8c00,0x8c00,"Alt-F12","AF12",true},
	{0x8d00,0x8d00,"Ctrl-Up","Ccu",true},
	{0x8de0,0x8de0,"Ctrl-Up","Ccu",true},
	{0x8e00,0x8e00,"Ctrl-Keypad -","C-",true},
	{0x8f00,0x8f00,"Ctrl-Keypad 5","C5",true},
	{0x9000,0x9000,"Ctrl-Keypad +","C+",true},
	{0x9100,0x9100,"Ctrl-Down","Ccd",true},
	{0x91e0,0x91e0,"Ctrl-Down","Ccd",true},
	{0x9200,0x9200,"Ctrl-Insert","Cins",true},
	{0x92e0,0x92e0,"Ctrl-Insert","Cins",true},
	{0x9300,0x9300,"Ctrl-Delete","Cdel",true},
	{0x93e0,0x93e0,"Ctrl-Delete","Cdel",true},
	{0x9400,0x9400,"Ctrl-Tab","Ctab",true},
	{0x9500,0x9500,"Ctrl-Keypad /","C/",true},
	{0x9600,0x9600,"Ctrl-Keypad *","C*",true},
	{0x9700,0x9700,"Alt-Home","Ahm",true},
	{0x9800,0x9800,"Alt-Up","Acu",true},
	{0x9900,0x9900,"Alt-Page Up","Apu",true},
	{0x9b00,0x9b00,"Alt-Left","Acl",true},
	{0x9d00,0x9d00,"Alt-Right","Acr",true},
	{0x9f00,0x9f00,"Alt-End","Aend",true},
	{0xa000,0xa000,"Alt-Down","Acd",true},
	{0xa100,0xa100,"Alt-Page Down","Apd",true},
	{0xa200,0xa200,"Alt-Insert","Ains",true},
	{0xa300,0xa300,"Alt-Delete","Adel",true},
	{0xa400,0xa400,"Alt-Keypad /","A/",true},
	{0xa500,0xa500,"Alt-Tab","Atab",true},
	{0xa600,0x1c00,"Alt-Enter","Aret",true},
	{0xe00a,0x1c0a,"Ctrl-Enter","Cret",true},
	{0xe00d,0x1c0d,"Enter","ret",true}, // Keypad Enter
	{0xe02f,0xe02f,"Keypad /","/",false}
};
