/*
 * Extended Operating System Loader (XOSL)
 * Copyright (c) 1999 by Geurt Vos
 *
 * This code is distributed under GNU General Public License (GPL)
 *
 * The full text of the license can be found in the GPL.TXT file,
 * or at http://www.gnu.org
 */


#include "menus.h"
#include <string.h>
#include <stdlib.h>
#include <memory.h>

static const char *YesNoList[2] = {"Ano", "Ne"};


CInstallMenus::CInstallMenus(CTextUI &TextUIToUse, CData &DataToUse, CPartList &PartListToUse, int FatAvailToUse):
	TextUI(TextUIToUse),
	Data(DataToUse),
	PartList(PartListToUse)
{
	FatAvail = FatAvailToUse;
	DosDriveList = NULL;
	PartNameList = NULL;
}

CInstallMenus::~CInstallMenus()
{
	if (DosDriveList) {
		delete DosDriveList[0];
		delete DosDriveList;
	}
}

void CInstallMenus::InitMainMenu(CTextList::TListItemExecute MenuHandler, void *HandlerClass)
{
	TextUI.ConnectEventHandler(MenuHandler,HandlerClass);
	
	TextUI.ClearMenu();
	TextUI.SetMenuTitle(" Hlavn \xcd\xcd\xcd\xcd\xcd");
	TextUI.AddMenuItem(0,"Nainstalovat XOSL","Nainstaluje Extended Operating System Loader 1.1.5 CZ",1);
	TextUI.AddMenuItem(2,"Odinstalovat XOSL","Odinstaluje Extended Operating System Loader 1.1.5 CZ",1);
	TextUI.AddMenuItem(4,"Obnovit XOSL","Obnov spoutn XOSLu po startu (typicky po instalaci OS)",1);

	TextUI.AddMenuItem(6,"Konec","Skon bez instalace Extended Operating System Loader 1.1.5 CZ",1);
	TextUI.SetItemIndex(0);
	TextUI.RefreshMenu();
}

void CInstallMenus::InitInstallMenu(CTextList::TListItemExecute MenuHandler, void *HandlerClass)
{
	TextUI.ConnectEventHandler(MenuHandler,HandlerClass);
	
	TextUI.ClearMenu();
	TextUI.SetMenuTitle(" Instalace \xcd\xcd");
	TextUI.AddMenuItem(0,"Nainstalovat na jednotku DOS","Nainstaluje XOSL 1.1.5 CZ na jednotku DOS (FAT16/FAT32)",FatAvail);
	TextUI.AddMenuItem(2,"Nainstalovat na samostatn oddl","Nainstaluje XOSL 1.1.5 CZ na existujc samostatn oddl",1);
	TextUI.AddMenuItem(6,"Zpt do hlavnho menu","Zpt do hlavnho menu",1);
	TextUI.SetItemIndex(FatAvail ? 0 : 2);
	TextUI.RefreshMenu();
}

void CInstallMenus::InitFixMbrMenu(CTextList::TListItemExecute MenuHandler, void *HandlerClass)
{
	TextUI.ConnectEventHandler(MenuHandler,HandlerClass);
	
	TextUI.ClearMenu();
	TextUI.SetMenuTitle(" Obnovit \xcd\xcd");
	TextUI.AddMenuItem(0,"Obnovit na jednotce DOS","Obnov XOSL 1.1.5 CZ nainstalovan na jednotku DOS",FatAvail);
	TextUI.AddMenuItem(2,"Obnovit na samostatnm oddlu","Obnov XOSL 1.1.5 CZ nainstalovan na samostatnm oddlu",1);
	TextUI.AddMenuItem(6,"Zpt do hlavnho menu","Zpt do hlavnho menu",1);
	TextUI.SetItemIndex(FatAvail ? 0 : 2);
	TextUI.RefreshMenu();
}

void CInstallMenus::InitUninstallMenu(CTextList::TListItemExecute MenuHandler, void *HandlerClass)
{
	TextUI.ConnectEventHandler(MenuHandler,HandlerClass);
	
	TextUI.ClearMenu();
	TextUI.SetMenuTitle(" Odinstalovat ");
	TextUI.AddMenuItem(0,"Odinstalovat z jednotky DOS","Odinstaluje XOSL 1.1.5 CZ z jednotky DOS",FatAvail);
	TextUI.AddMenuItem(2,"Odinstalovat ze samostatnho oddlu","Odinstaluje XOSL 1.1.5 CZ ze samostatnho oddlu",1);
	TextUI.AddMenuItem(6,"Zpt do hlavnho menu","Zpt do hlavnho menu",1);
	TextUI.SetItemIndex(FatAvail ? 0 : 2);
	TextUI.RefreshMenu();
}

void CInstallMenus::InitInstFatMenu(CTextList::TListItemExecute MenuHandler, void *HandlerClass)
{
	const char **ModeNameList;
	int ModeCount;
	const char **MouseTypeNames;
	int MouseTypeCount;

	Data.GetGraphicsModeNames(ModeNameList,ModeCount);
	Data.GetMouseTypeNames(MouseTypeNames,MouseTypeCount);
	if (!DosDriveList)
		CreateDosDriveList();

	TextUI.ConnectEventHandler(MenuHandler,HandlerClass);
	TextUI.ClearMenu();
	TextUI.AddMenuItem(0,"Rozlien obrazovky","Vchoz rozlien obrazovky",1,ModeCount,ModeNameList,1);
	TextUI.AddMenuItem(1,"Typ myi","Vchoz typ myi",1,MouseTypeCount,MouseTypeNames,1);
	TextUI.AddMenuItem(2,"Jednotka k instalaci","Jednotka, na kterou se m XOSL nainstalovat",1,DosDriveCount,(const char **)DosDriveList,1);
	TextUI.AddMenuItem(3,"Ranish Partition Manager","Nainstalovat Ranish Partition Manager 2.38 beta 1.9 spolen s XOSL 1.1.5 CZ",1,2,YesNoList,1);
	TextUI.AddMenuItem(4,"Smart Boot Manager","Nainstalovat Smart Boot Manager 3.7.1 pro podporu spoutn z CD-ROM.",1,2,YesNoList,1);

	TextUI.AddMenuItem(6,"Spustit instalaci","Nainstalovat Extended Operating System Loader 1.1.5 CZ",1);
	TextUI.AddMenuItem(8,"Zpt do menu instalace","Zpt do menu Instalace",1);
	TextUI.SetItemIndex(0);
	TextUI.RefreshMenu();
}

void CInstallMenus::InitInstSepMenu(CTextList::TListItemExecute MenuHandler, void *HandlerClass)
{
	const char **ModeNameList;
	int ModeCount;
	const char **MouseTypeNames;
	int MouseTypeCount;

	Data.GetGraphicsModeNames(ModeNameList,ModeCount);
	Data.GetMouseTypeNames(MouseTypeNames,MouseTypeCount);
	if (!PartNameList)
		CreatePartList();

	TextUI.ConnectEventHandler(MenuHandler,HandlerClass);
	TextUI.ClearMenu();
	TextUI.AddMenuItem(0,"Rozlien obrazovky","Vchoz rozlien obrazovky",1,ModeCount,ModeNameList,1);
	TextUI.AddMenuItem(1,"Typ myi","Vchoz typ myi",1,MouseTypeCount,MouseTypeNames,1);
	TextUI.AddMenuItem(2,"Ranish Partition Manager","Nainstalovat Ranish Partition Manager 2.38 beta 1.9 spolen s XOSL 1.1.5 CZ",1,2,YesNoList,1);
	TextUI.AddMenuItem(3,"Smart Boot Manager","Nainstalovat Smart Boot Manager 3.7.1 pro podporu spoutn z CD-ROM.",1,2,YesNoList,1);
	TextUI.AddMenuItem(4,"Dsk Typ  Systm              Vel  ","Oddl na instalaci XOSL 1.1.5 CZ",1,PartNameCount,(const char **)PartNameList,0);
	TextUI.AddMenuItem(10,"Spustit instalaci","Nainstalovat Extended Operating System Loader 1.1.5 CZ",1);
	TextUI.AddMenuItem(11,"Zpt do menu instalace","Zpt do menu Instalace",1);
	TextUI.SetItemIndex(0);
	TextUI.RefreshMenu();
}


void CInstallMenus::InitErrorMenu(CTextList::TListItemExecute MenuHandler, void *HandlerClass)
{
	TextUI.ConnectEventHandler(MenuHandler,HandlerClass);
	TextUI.ClearMenu();
	TextUI.SetMenuTitle(" Chyba \xcd\xcd\xcd\xcd");
	TextUI.AddMenuItem(0,"Vyskytla se chyba!","",0);
	TextUI.AddMenuItem(2,"Konec instalace","Konec bez instalace Extended Operating System Loader 1.1.5 CZ",1);
	TextUI.AddMenuItem(4,"Zpt do hlavnho menu","Zpt do hlavnho menu",1);
	TextUI.SetItemIndex(2);
	TextUI.RefreshMenu();
}

void CInstallMenus::InitDoneMenu(CTextList::TListItemExecute MenuHandler, void *HandlerClass)
{
	TextUI.ConnectEventHandler(MenuHandler,HandlerClass);
	TextUI.ClearMenu();
	TextUI.AddMenuItem(0,"Extended Operating System Loader","",0);
	TextUI.AddMenuItem(1,"byl spn nainstalovn","",0);

	TextUI.AddMenuItem(3,"Restartovat systm","Konec instalace a restartovat, aby se poprv spustil XOSL",1);
	TextUI.AddMenuItem(5,"Konec instalace","Konec instalace bez restartu",1);
	TextUI.AddMenuItem(7,"Zpt do hlavnho menu","Zpt do hlavnho menu",1);
	TextUI.SetItemIndex(3);
	TextUI.RefreshMenu();
}

void CInstallMenus::InitUnDoneMenu(CTextList::TListItemExecute MenuHandler, void *HandlerClass)
{
	TextUI.ConnectEventHandler(MenuHandler,HandlerClass);
	TextUI.ClearMenu();
	TextUI.AddMenuItem(0,"Extended Operating System Loader","",0);
	TextUI.AddMenuItem(1,"byl spn odinstalovn","",0);

	TextUI.AddMenuItem(3,"Restartovat systm","Konec instalace a restartovat",1);
	TextUI.AddMenuItem(5,"Konec instalace","Zavt instaltor",1);
	TextUI.AddMenuItem(7,"Zpt do hlavnho menu","Zpt do hlavnho menu",1);
	TextUI.SetItemIndex(3);
	TextUI.RefreshMenu();
}

void CInstallMenus::InitUninstallFat(CTextList::TListItemExecute MenuHandler, void *HandlerClass)
{
	static const char *MbrIplList[2] = { "Originln","Vchoz" };

	if (!DosDriveList)
		CreateDosDriveList();

	TextUI.ConnectEventHandler(MenuHandler,HandlerClass);

	TextUI.ClearMenu();
	TextUI.AddMenuItem(0,"Odinstalovat z jednotky","Jednotka, na kter je XOSL prv nainstalovn",1,DosDriveCount,(const char **)DosDriveList,1);
	TextUI.AddMenuItem(1,"Obnovit MBR","Obnovit Master Boot Record originlnm i vchozm zavad؟em",1,2,MbrIplList,1);
	TextUI.AddMenuItem(4,"Spustit odinstalaci","Odinstaluje Extended Operating System Loader",1);
	TextUI.AddMenuItem(6,"Zpt do menu odinstalace","Zpt do menu odinstalace",1);
	TextUI.SetItemIndex(0);
	TextUI.RefreshMenu();

}

void CInstallMenus::InitUninstallSep(CTextList::TListItemExecute MenuHandler, void *HandlerClass)
{
	static const char *MbrIplList[2] = { "Original","Default" };

	if (!PartNameList)
		CreatePartList();

	TextUI.ConnectEventHandler(MenuHandler,HandlerClass);

	TextUI.ClearMenu();
	TextUI.AddMenuItem(0,"Obnovit MBR","Obnovit Master Boot Record originlnm i vchozm zavad؟em",1,2,MbrIplList,1);
	TextUI.AddMenuItem(2,"Dsk Typ  Systm              Vel  ","Oddl, na kterm je XOSL prv nainstalovn",1,PartNameCount,(const char **)PartNameList,0);
	TextUI.AddMenuItem(8,"Spustit odinstalaci","Odinstaluje Extended Operating System Loader",1);
	TextUI.AddMenuItem(10,"Zpt do menu odinstalace","Zpt do menu odinstalace",1);
	TextUI.SetItemIndex(0);
	TextUI.RefreshMenu();

}

void CInstallMenus::InitFixMbrFat(CTextList::TListItemExecute MenuHandler, void *HandlerClass)
{
	if (!DosDriveList)
		CreateDosDriveList();

	TextUI.ConnectEventHandler(MenuHandler,HandlerClass);

	TextUI.ClearMenu();
	TextUI.AddMenuItem(0,"XOSL na jednotce","Jednotka DOS, na kter je XOSL prv nainstalovn",1,DosDriveCount,(const char **)DosDriveList,1);
	TextUI.AddMenuItem(4,"Spustit obnoven","Obnovit XOSL 1.1.5 CZ",1);
	TextUI.AddMenuItem(6,"Zpt do menu obnoven","Zpt do menu obnoven",1);
	TextUI.SetItemIndex(0);
	TextUI.RefreshMenu();

}

void CInstallMenus::InitFixMbrSep(CTextList::TListItemExecute MenuHandler, void *HandlerClass)
{
	if (!PartNameList)
		CreatePartList();

	TextUI.ConnectEventHandler(MenuHandler,HandlerClass);

	TextUI.ClearMenu();
	TextUI.AddMenuItem(0,"Dsk Typ  Systm              Vel  ","Oddl, na kterm je XOSL prv nainstalovn",1,PartNameCount,(const char **)PartNameList,0);
	TextUI.AddMenuItem(6,"Spustit obnoven","Obnovit XOSL 1.1.5 CZ",1);
	TextUI.AddMenuItem(8,"Zpt do menu obnoven","Zpt do menu obnoven",1);
	TextUI.SetItemIndex(0);
	TextUI.RefreshMenu();

}


void CInstallMenus::CreateDosDriveList()
{
	int Index;
	int *Buffer;

	DosDriveCount = Data.GetLastDrive() - ('C' - 'A');
	DosDriveList = new char *[DosDriveCount];
	Buffer = new int[DosDriveCount];
	for (Index = 0; Index < DosDriveCount; ++Index) {
		Buffer[Index] = Index + 'C';
		DosDriveList[Index] = (char *)&Buffer[Index];
	}
}

void CInstallMenus::CreatePartList()
// TODO: Implement the sprintf() function
{
	char *PartStr;
	const TPartition *Partition;
	int Index, Count;

	Count = PartList.GetCount();
	PartNameList = new char *[Count];
	PartResolveList = new int[Count];

	for (PartNameCount = Index = 0; Index < Count; ++Index) {
		Partition = PartList.GetPartition(Index);
		switch (Partition->Type) {
			case PART_PRIMARY:
			case PART_LOGICAL:
				switch (Partition->FSType) {
					case 0x05: // Extended
					case 0x0f: // Extended LBA
					case 0x85: // Linux Extended
						PartResolveList[Index] = -1;
						break;
					default:
						PartResolveList[Index] = PartNameCount;

						PartStr = new char [48];
						MemSet(PartStr,' ',32);
						MemCopy(PartStr,"HD",2);
						PartStr[2] = '0' + (Partition->Drive & ~0x80);
						MemCopy(&PartStr[4],Partition->Type == PART_PRIMARY ? "pri" : "log",3);
						MemCopy(&PartStr[9],Partition->FSName,strlen(Partition->FSName));
						itoa(Partition->SectorCount >> 11,&PartStr[29],10);
						PartNameList[PartNameCount++] = PartStr;
						break;
				}
				break;
			default:
				break;
		}
	}

}

int CInstallMenus::ResolvePartIndex(int ListIndex)
{
	int Count, Index;

	Count = PartList.GetCount();
	for (Index = 0; Index < Count; ++Index)
		if (PartResolveList[Index] == ListIndex)
			return Index;
	return -1;
}
